// $Id: CColour.cpp,v 1.6 2007/02/08 21:07:54 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CColour.hpp"
#include <Basics/CString.hpp>
using Exponent::Basics::CString;
using Exponent::GUI::Basics::CColour;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CColour, CCountedObject);

//	===========================================================================
const CColour CColour::CCOLOUR_BLACK = CColour(0, 0, 0);

//	===========================================================================	
const CColour CColour::CCOLOUR_WHITE = CColour(255,	255, 255);

//	===========================================================================
const CColour CColour::CCOLOUR_RED = CColour(243, 32, 32);

//	===========================================================================
const CColour CColour::CCOLOUR_GREEN = CColour(102,	200, 85);

//	===========================================================================
const CColour CColour::CCOLOUR_BLUE = CColour(85, 86, 200);

//	===========================================================================
const CColour CColour::CCOLOUR_YELLOW = CColour(219, 230, 49);

//	===========================================================================
const CColour CColour::CCOLOUR_ORANGE = CColour(239, 149, 41);

//	===========================================================================
const CColour CColour::CCOLOUR_TURQUOISE = CColour(116, 184, 188);

//	===========================================================================
const CColour CColour::CCOLOUR_PURPLE = CColour(153, 116, 188);

//	===========================================================================
const CColour CColour::CCOLOUR_PINK = CColour(226, 74, 160);

//	===========================================================================
const CColour CColour::CCOLOUR_LIGHT_GREY = CColour(208, 208, 208);

//	===========================================================================
const CColour CColour::CCOLOUR_DARK_GREY = CColour(147, 147, 147);

//	===========================================================================
CColour::CColour(const unsigned long red, const unsigned long green, const unsigned long blue) : m_red(255), m_green(255), m_blue(255)
{
	EXPONENT_CLASS_CONSTRUCTION(CColour);
	this->setColour(red, green, blue);
}

//	===========================================================================
CColour::CColour() : m_red(255), m_green(255), m_blue(255)
{
	EXPONENT_CLASS_CONSTRUCTION(CColour);
	this->setColour(255, 255, 255);
}

//	===========================================================================
CColour::CColour(const CColour &colour) : m_red(255), m_green(255), m_blue(255)
{
	EXPONENT_CLASS_CONSTRUCTION(CColour);
	this->setColour(colour.getRed(), colour.getGreen(), colour.getBlue());
}

#ifdef WIN32
//	===========================================================================
CColour::CColour(COLORREF &colour) : m_red(255), m_green(255), m_blue(255)
{
	EXPONENT_CLASS_CONSTRUCTION(CColour);
	this->setFromColourRef(colour);
}
#else
//	===========================================================================
CColour::CColour(const RGBColor &colour) : m_red(255), m_green(255), m_blue(255)
{
	EXPONENT_CLASS_CONSTRUCTION(CColour);
	this->setFromRGBColour(colour);
}
#endif

//	===========================================================================
CColour::~CColour()
{
	EXPONENT_CLASS_DESTRUCTION(CColour);
}

//	===========================================================================
CColour &CColour::operator = (const CColour &colour)
{
	this->setColour(colour.getRed(), colour.getGreen(), colour.getBlue());
	return (*this);
}

//	===========================================================================
CColour &CColour::operator += (const CColour &colour)
{
	// Append to red
	m_red += colour.getRed();
	if (m_red > 255) 
	{
		m_red = 255;
	}

	// Append to green
	m_green += colour.getGreen();
	if (m_green > 255) 
	{
		m_green = 255;
	}

	// Append to blue
	m_blue += colour.getBlue();
	if (m_blue > 255) 
	{
		m_blue = 255;
	}

	return (*this);
};

//	===========================================================================
bool CColour::operator == (const CColour &colour)
{
	return ((m_red == colour.getRed()) && (m_green == colour.getGreen()) && (m_blue == colour.getBlue()));
}

//	===========================================================================
void CColour::setColour(const unsigned long red, const unsigned long green, const unsigned long blue)
{
	m_red   = red;
	m_green = green;
	m_blue  = blue;
}

//	===========================================================================
void CColour::getObjectDescription(char *string, const long size) const
{
	CString myString;
	myString.setStringWithFormat("[%li,%li,%li]", m_red, m_green, m_blue);
	myString.getString(string, size);
}

#ifdef WIN32
//	===========================================================================
COLORREF CColour::getAsColourRef() const
{
	return RGB(m_red, m_green, m_blue);
}

//	===========================================================================
void CColour::setFromColourRef(const COLORREF &colour)
{
	this->setRed(GetRValue(colour));
	this->setGreen(GetGValue(colour));
	this->setBlue(GetBValue(colour));
}
#else
//	===========================================================================
void CColour::setFromRGBColour(const RGBColor &colour)
{
	this->setRed(fromAppleValue(colour.red));
	this->setGreen(fromAppleValue(colour.green));
	this->setBlue(fromAppleValue(colour.blue));
}

//	===========================================================================
RGBColor *CColour::getAsRGBColour() const
{
	RGBColor *colour = new RGBColor;
	colour->red   = toAppleValue(m_red);
	colour->green = toAppleValue(m_green);
	colour->blue  = toAppleValue(m_blue);
	return colour;
}

//	===========================================================================
unsigned short CColour::toAppleValue(const long value)
{
	const double doubleValue = value / 255.0;
	return (unsigned short)(doubleValue * 0xFFFF);
}

//	===========================================================================
long CColour::fromAppleValue(const unsigned short appleValue)
{
	const double doubleValue = (double) (appleValue / 0xFFFF);
	return (long)(doubleValue * 255);
}
#endif